% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_helper_functions.R
\name{assign_behavior}
\alias{assign_behavior}
\title{Assign behavior estimates to observations}
\usage{
assign_behavior(dat.orig, dat.seg.list, theta.estim.long, behav.names)
}
\arguments{
\item{dat.orig}{A data frame that contains all of the original data for all
animal IDs. Must be same as was used to originally segment the tracks. Must
have columns \code{obs} and \code{time1} generated by
\code{\link{filter_time}}.}

\item{dat.seg.list}{A list of data associated with each animal ID where names
of list elements are the ID names and tracks have already been segmented.
Must have columns \code{obs} and \code{time1} generated by
\code{\link{filter_time}}.}

\item{theta.estim.long}{A data frame in long format where each observation
(\emph{time1}) of each track segment (\emph{tseg}) of each animal ID
(\emph{id}) has separate rows for behavior proportion estimates per state.
Columns for behavior and proportion estimates should be labeled
\emph{behavior} and \emph{prop}, respectively. Date (in POSIXct format)
should also be included as a column labeled \emph{date}.}

\item{behav.names}{character. A vector of names to label each state (in
order).}
}
\value{
A data frame of all animal IDs where columns (with names from
  \code{behav.names}) include proportions of each behavioral state per
  observation, as well as a column that stores the dominant behavior within a
  given track segment for which the observation belongs (\code{behav}). This
  is merged with the original data frame \code{dat.orig}, so any observations
  that were excluded (not at primary time interval) will show \code{NA} for
  behavior estimates.
}
\description{
Assign behavior estimates to observations
}
\examples{

\donttest{
#load original and segmented data
data(tracks)
data(tracks.seg)

#convert segmented dataset into list
tracks.list<- df_to_list(dat = tracks.seg, ind = "id")

#select only id, tseg, SL, and TA columns
tracks.seg2<- tracks.seg[,c("id","tseg","SL","TA")]

#summarize data by track segment
obs<- summarize_tsegs(dat = tracks.seg2, nbins = c(5,8))

#cluster data with LDA
res<- cluster_segments(dat = obs, gamma1 = 0.1, alpha = 0.1, ngibbs = 1000,
                       nburn = 500, nmaxclust = 7, ndata.types = 2)

#Extract proportions of behaviors per track segment
theta.estim<- extract_prop(res = res, ngibbs = 1000, nburn = 500, nmaxclust = 7)

#Create augmented matrix by replicating rows (tsegs) according to obs per tseg
theta.estim.long<- expand_behavior(dat = tracks.seg, theta.estim = theta.estim, obs = obs,
                               nbehav = 3, behav.names = c("Encamped","ARS","Transit"),
                               behav.order = c(1,2,3))

#Run function
dat.out<- assign_behavior(dat.orig = tracks, dat.seg.list = tracks.list,
                          theta.estim.long = theta.estim.long,
                          behav.names = c("Encamped","ARS","Transit"))
}


}
