% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_gibbs_functions.R
\name{log_marg_likel}
\alias{log_marg_likel}
\title{Internal function that calculates the log marginal likelihood of each model
being compared}
\usage{
log_marg_likel(alpha, summary.stats, nbins, ndata.types)
}
\arguments{
\item{alpha}{numeric. A single value used to specify the hyperparameter for
the prior distribution. A standard value for \code{alpha} is typically 1,
which corresponds with a vague prior on the Dirichlet distribution.}

\item{summary.stats}{A matrix of sufficient statistics returned from
\code{\link{get_summary_stats}}.}

\item{nbins}{numeric. A vector of the number of bins used to discretize each
movement variable.}

\item{ndata.types}{numeric. The length of \code{nbins}.}
}
\value{
The log marginal likelihood is calculated for a model with a given
  set of breakpoints and the discretized data.
}
\description{
An internal function that is used to calculate the log marginal likelihood of
models for the current and proposed sets of breakpoints. Called within
\code{\link{samp_move}}.
}
