% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbnec.R
\name{ggbnec.bayesmanecfit}
\alias{ggbnec.bayesmanecfit}
\title{ggbnec.bayesmanecfit}
\usage{
\method{ggbnec}{bayesmanecfit}(
  x,
  nec = TRUE,
  ecx = FALSE,
  ...,
  all = TRUE,
  plot = TRUE,
  ask = TRUE,
  newpage = TRUE,
  multi_facet = FALSE
)
}
\arguments{
\item{x}{An object of class \code{\link{bayesmanecfit}} as returned by
function \code{\link{bnec}}.}

\item{nec}{Should NEC values be added to the plot? Defaults to TRUE.}

\item{ecx}{Should ECx values be added to the plot? Defaults to FALSE.}

\item{...}{Additional arguments to be passed to \code{\link{ggbnec_data}}.}

\item{all}{Should all individual models be plotted separately (defaults to
TRUE) or should model averaged predictions be plotted instead?}

\item{plot}{Should output \code{\link[ggplot2]{ggplot}} output be plotted?
Only relevant if \code{all = TRUE} and \code{multi_facet = FALSE}.}

\item{ask}{Indicates if the user is prompted before a new page is plotted.
Only relevant if \code{plot = TRUE} and \code{multi_facet = FALSE}.}

\item{newpage}{Indicates if the first set of plots should be plotted to a
new page. Only relevant if \code{plot = TRUE} and
\code{multi_facet = FALSE}.}

\item{multi_facet}{Should all plots be plotted in one single panel via
facets? Defaults to FALSE.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
\code{\link[bayesnec:bayesnec-package]{bayesnec}} standard ggplot method.
}
\examples{
\donttest{
library(bayesnec)
data(manec_example)

ggbnec_data(manec_example)
ggbnec_data(manec_example, add_ecx = TRUE, ecx_val = 50)
}

}
