% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbnec.R
\name{ggbnec.bayesnecfit}
\alias{ggbnec.bayesnecfit}
\title{ggbnec.bayesnecfit}
\usage{
\method{ggbnec}{bayesnecfit}(x, nec = TRUE, ecx = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{\link{bayesnecfit}} as returned by
function \code{\link{bnec}}.}

\item{nec}{Should NEC values be added to the plot? Defaults to TRUE.}

\item{ecx}{Should ECx values be added to the plot? Defaults to FALSE.}

\item{...}{Additional arguments to be passed to \code{\link{ggbnec_data}}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
\code{\link[bayesnec:bayesnec-package]{bayesnec}} standard ggplot method.
}
\examples{
\donttest{
library(bayesnec)
data(manec_example)

ggbnec_data(manec_example)
ggbnec_data(manec_example, add_ecx = TRUE, ecx_val = 50)
}

}
