% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_endpoints.R
\name{average_endpoints}
\alias{average_endpoints}
\title{average_endpoints}
\usage{
average_endpoints(
  x,
  endpoint = "nec",
  ecx_val = 10,
  posterior = FALSE,
  type = "absolute",
  hormesis_def = "control",
  sig_val = 0.01,
  precision = 1000,
  x_range = NA,
  xform = identity,
  prob_vals = c(0.5, 0.025, 0.975)
)
}
\arguments{
\item{x}{A named \code{\link[base]{list}} of objects of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}} returned by
\code{\link{bnec}}.}

\item{endpoint}{The type of endpoint to use in the mean. Takes values
"nec", "ecx" or "nsec".}

\item{ecx_val}{The desired percentage effect value. This must be a value
between 1 and 99 (for type = "relative" and "absolute"), defaults to 10.}

\item{posterior}{A \code{\link[base]{logical}} value indicating if the full
posterior sample of calculated ECx values should be returned instead of
just the median and 95 credible intervals.}

\item{type}{A \code{\link[base]{character}} vector, taking values of
"relative", "absolute" (the default) or "direct". See Details.}

\item{hormesis_def}{A \code{\link[base]{character}} vector, taking values
of "max" or "control". See Details.}

\item{sig_val}{Probability value to use as the lower quantile to test
significance of the predicted posterior values.
against the lowest observed concentration (assumed to be the control), to
estimate NEC as an interpolated NOEC value from smooth ECx curves.}

\item{precision}{The number of unique x values over which to find ECx --
large values will make the ECx estimate more precise.}

\item{x_range}{A range of x values over which to consider extracting ECx.}

\item{xform}{A function to apply to the returned estimated concentration
values.}

\item{prob_vals}{A vector indicating the probability values over which to
return the estimated ECx value. Defaults to 0.5 (median) and 0.025 and
0.975 (95 percent credible intervals).}
}
\value{
The geometric mean of the endpoints estimate values
of the \code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}}
model fits contained in \code{x}. See Details.
}
\description{
Extracts posterior predicted endpoint values from a list of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}} model fits and
calculates a geometric mean.
}
\details{
The geometric mean of values are simply the mean calculated on a
log scale and back transformed through \code{\link[base]{exp}}, although we
have added the capacity to accommodate zero values. Note that the function
assumes that \code{x} has been modelled on the natural scale. Often C-R
models are more stable on a log-transformed or sqrt scaling. If the input
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}} model fits are
already based on a re-scaling of the x (concentration) axis, it is important
to pass an appropriate xform argument to ensure these are back transformed
before the the geometric mean calculation is applied.
}
\examples{
\dontrun{
library(brms)
library(bayesnec)
data(manec_example)
nec4param <- pull_out(manec_example, model = "nec4param")
ecx4param <- pull_out(manec_example, model = "ecx4param")
average_endpoints(list("nec" = ecx4param, "ecx" = nec4param), ecx_val = 50)
}

}
\seealso{
\code{\link{bnec}}
}
