% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.bayesnecfit}
\alias{summary.bayesmanecfit}
\title{Generates a summary for objects fitted by \code{\link{bnec}}}
\usage{
\method{summary}{bayesnecfit}(object, ..., ecx = FALSE, ecx_vals = c(10, 50, 90))

\method{summary}{bayesmanecfit}(object, ..., ecx = FALSE, ecx_vals = c(10, 50, 90))
}
\arguments{
\item{object}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.}

\item{...}{Unused.}

\item{ecx}{Should summary ECx values be calculated? Defaults to FALSE.}

\item{ecx_vals}{ECx targets (between 1 and 99). Only relevant if ecx = TRUE.
If no value is specified by the user, returns calculations for EC10, EC50,
and EC90.}
}
\value{
A summary of the fitted model. In the case of a
\code{\link{bayesnecfit}} object, the summary contains most of the original
contents of a \code{\link[brms]{brmsfit}} object with the addition of
an R2. In the case of a \code{\link{bayesmanecfit}} object, summary
displays the family distribution information, model weights and averaging
method, the estimated model-averaged NEC, and R2 estimates for each
individual model. Warning messages are also printed to screen in case
model fits are not satisfactory with regards to their Rhats.
}
\description{
Generates a summary for objects fitted by \code{\link{bnec}}.
\code{object} should be of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.
}
\examples{
\donttest{
library(bayesnec)
summary(manec_example)
nec4param <- pull_out(manec_example, "nec4param")
summary(nec4param)
}
}
