% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_density.R
\name{density_at}
\alias{density_at}
\title{Density Probability at a Given Value}
\usage{
density_at(posterior, x, precision = 2^10, method = "kernel", ...)
}
\arguments{
\item{posterior}{Vector representing a posterior distribution.}

\item{x}{The value of which to get the approximate probability.}

\item{precision}{Number of points of density data. See the \code{n} parameter in \code{density}.}

\item{method}{Density estimation method. Can be \code{"kernel"} (default), \code{"logspline"} or \code{"KernSmooth"}.}

\item{...}{Currently not used.}
}
\description{
Compute the density value at a given point of a distribution (i.e., the value of the \code{y} axis of a value \code{x} of a distribution).
}
\examples{
library(bayestestR)
posterior <- distribution_normal(n = 10)
density_at(posterior, 0)
density_at(posterior, c(0, 1))
}
