% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_estimate.R
\name{map_estimate}
\alias{map_estimate}
\alias{map_estimate.numeric}
\alias{map_estimate.stanreg}
\alias{map_estimate.brmsfit}
\title{Maximum A Posteriori (MAP) Estimate}
\usage{
map_estimate(x, ...)

\method{map_estimate}{numeric}(x, precision = 2^10, ...)

\method{map_estimate}{stanreg}(x, precision = 2^10,
  effects = c("fixed", "random", "all"), parameters = NULL, ...)

\method{map_estimate}{brmsfit}(x, precision = 2^10,
  effects = c("fixed", "random", "all"), component = c("conditional",
  "zi", "zero_inflated", "all"), parameters = NULL, ...)
}
\arguments{
\item{x}{Vector representing a posterior distribution. Can also be a
\code{stanreg} or \code{brmsfit} model.}

\item{...}{Currently not used.}

\item{precision}{Number of points of density data. See the \code{n} parameter in \link[=density]{density}.}

\item{effects}{Should results for fixed effects, random effects or both be returned?
Only applies to mixed models. May be abbreviated.}

\item{parameters}{Regular expression pattern that describes the parameters that
should be returned. Meta-parameters (like \code{lp__} or \code{prior_}) are
filtered by default, so only parameters that typically appear in the
\code{summary()} are returned. Use \code{parameters} to select specific parameters
for the output.}

\item{component}{Should results for all parameters, parameters for the conditional model
or the zero-inflated part of the model be returned? May be abbreviated. Only
applies to \pkg{brms}-models.}
}
\value{
A numeric value if \code{posterior} is a vector.
  If \code{density = TRUE}, or if \code{posterior} is a model-object, returns
  a data frame with following columns:
  \itemize{
    \item \code{Parameter} The model parameter(s), if \code{x} is a model-object. If \code{x} is a vector, this column is missing.
    \item \code{MAP} The MAP estimate for the posterior or each model parameter.
  }
}
\description{
Find the \strong{Highest Maximum A Posteriori (MAP)} estimate of a posterior, \emph{i.e.,} the most probable value. It corresponds to the "peak" (or the \emph{mode}) of the posterior distribution. Note this function relies on \link{estimate_density}, which by default uses a different smoothing bandwidth (\code{"SJ"}) from the legacy default implemented the base R \link{density} function (\code{"nrd0"}).
}
\examples{
library(bayestestR)

posterior <- rnorm(10000)
map_estimate(posterior)

plot(density(posterior))
abline(v = map_estimate(posterior), col = "red")
\dontrun{
library(rstanarm)
model <- rstanarm::stan_glm(mpg ~ wt + cyl, data = mtcars)
map_estimate(model)

library(brms)
model <- brms::brm(mpg ~ wt + cyl, data = mtcars)
map_estimate(model)
}

}
