% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getUSGSflow.R
\name{getUSGSflow}
\alias{getUSGSflow}
\title{Retrieve USGS daily flow data in a wide format}
\usage{
getUSGSflow(siteNumber, yearStart, yearEnd, fill = TRUE, span = 10,
  max.fill = 10)
}
\arguments{
\item{siteNumber}{List of site numbers}

\item{yearStart}{Beginning year of data retrieval}

\item{yearEnd}{Ending year of data retrieval}

\item{fill}{TRUE[default]/FALSE field indicating whether to fill in missing
values using with USGS' fillMissing function}

\item{span}{the maximum number of observations on each side of each range of
missing values to use in constructing the time series model [default=10]}

\item{max.fill}{the maximum gap to fill [default=10]}
}
\value{
USGS daily flow data for sites in a wide format
}
\description{
Retrieve USGS daily flow data from NWIS based on list of site IDs (relying on
dataRetrieval::readNWISdv and dataRetrieval::renameNWISColumns. The flow
and data qualifier code for each site is organized into two columns (e.g.,
"q10174500", "q101745000cd" for USGS gage 10174500). Flow is stored as cubic
meters per second [cms].
}
\details{
This function automatically 'fills in' missing values [unless the user turns
this feature off] using code developed by USGS (see smwrBase::fillMissing). 
The user can also control the maximum gap size to fill in. If a daily flow
value is missing, then the corresponding data qualifier fields is set to
'NaN'. The user can use this setting to identify which flows are filled in.
}
\examples{
# set retrieval parameters
yearStart   <- 2014
yearEnd     <- 2014
siteNumber <- c('01578310')

# regular retrieval (default usage)
df <- getUSGSflow(siteNumber, yearStart, yearEnd)

}
\keyword{internal}
