% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeCensored.R
\name{impute}
\alias{impute}
\title{Impute Censored Values}
\usage{
impute(x, imputeOption = "mid")
}
\arguments{
\item{x}{vector of type baytrends::qw}

\item{imputeOption}{imputation method [default= "mid"], valid impute options
are "lower", "upper", "mid", "norm", "lnorm"}
}
\value{
vector where x is transformed into a simple numeric variable
}
\description{
Impute value for multiply censored data.
}
\details{
The imputeOption values of lower, upper and mid impute the lower limit, upper limit,
and midpoint between the lower and upper limit. In the context of typical water quality
data, these options would be eqivalent to zero, detection limit and 1/2 detection limit
substitution. Options for substituting the normal ["norm"] or lognormal ["lnorm"] expectation
can also be used.
}
\examples{
x  <- dataCensored[1:20,"tdp"]
x.lower <- impute(x,'lower')
x.mid   <- impute(x,'mid')
x.upper <- impute(x,'upper')
x.norm  <- impute(x,'norm')
x.lnorm <- impute(x,'lnorm')
}
