% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_dlimit.R
\name{dlimit}
\alias{dlimit}
\title{Impute Detection Limits}
\usage{
dlimit(values, censor.codes, default = 1e-25)
}
\arguments{
\item{values}{the numeric values.}

\item{censor.codes}{logical or character, \code{TRUE} or "<" indicates
left-censored at value and \code{FALSE}, " " or "" indicates a quantified
value. Character codes "E" and "J" are censored at the current detection
limit. Other characters are ignored and generate a warning.}

\item{default}{the default detection limit value to assign to an uncensored
value that is less than the currently imputed detection limit value.}
}
\value{
A vector of detection limits matched with each of the input values.
}
\description{
Imputes values for missing detection limits for left-censored data.  From smwrQW package.
}
\note{
This function is based on the DLIMIT function in LOADEST (Runkel and
others, 2004). The general assumption for imputing detection limits is that
the data are sorted by time and the detection limits changes in a consistent
pattern over time.
}
\section{Warning}{
 Tim Cohn, written communication, 5 Nov 2002 states that
there are several problems with this approach:\cr

1) for large data sets, it may be difficult for the user to group the
observations into subsets as in the example above.  If the observations are
not grouped into subsets or the subsets do not have the censored observations
as the first records, incorrect detection limits may be applied to the
uncensored data.\cr

2) for the case of multiple constituents, it may be impossible to place the
censored observation within each subset at the top of the subset.  Consider
constituents Y and Z, each analyzed at Lab B, and each with one censored
observation.  The censored observations occur on different dates.  In this
case its not possible to have both observations as the first line in the
subset from Lab B. (Note: the user could work around this problem by doing
seperate runs for each constituent.)\cr

3) When a subset of observations is completely uncensored, the detection
limit from another subset will be applied.  Consider the example above, but
with the 10 observations from Lab B being completely uncensored.  In this
case, the detection limit from Lab A will be used for all 20 observations.\cr

4) When all of the observations are uncensored (no '<' signs for a given
constituent), there is no way for the user to specify the detection limit(s).
In this case, a default value of 1.E-25 is used for all observations
(consistent with ESTIMATOR).\cr

Despite these problems, the approach is satisfactory for most applications:
"the estimates are not very sensitive to the precise value of the censoring
threshold for the above-threshold values."
}

\examples{

## The actual detection limits are 2,2,2,1,1,1.
dlimit(c(2,2,3,1,1,2), c(" ", "<", " ", " ", "<", " "))

}
\references{
Runkel, R.L., Crawford, C.G., and Cohn, T.A., 2004, Load
estimator (LOADEST) a FORTRAN program for estiamting constituent laods in
streams and rivers: U.S. Gelogical Survey Techniques and Methods 4-A5, 69.
}
\seealso{
\code{\link{readNWQLdl}}
}
\keyword{internal}
\keyword{manip}
