% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layerAggregation.R
\name{layerAggregation}
\alias{layerAggregation}
\title{Aggregate data layers}
\usage{
layerAggregation(df, avgTechnique = "mean", layerAggOption = 3)
}
\arguments{
\item{df}{data frame}

\item{avgTechnique}{method for aggregating data ("mean" [default], "median")}

\item{layerAggOption}{(0[default]: no aggregation; 1: combine "S" & "AP"
("SAP"); 2: combine "B" & "BP" ("BBP"); 3: opt 1 & 2 ("SAP", "BBP"); 4:
combine all ("ALL")); 5: combine "S" and "B" ("SB")}
}
\value{
data frame with aggregated data
}
\description{
This function aggregates data layers. Steps: 1) Perform first level error checking
to make sure that the data set contains 'layer' and valid aggregation option was
selected. 2) Perform second level error checking to make sure the aggregation option
selection makes sense (e.g. cannot aggregate "S" and "AP" if no "AP" data are in the
data set). 3) Average the data by taking the median or mean based on user input.
}
\examples{
\dontrun{
dfr    <- analysisOrganizeData(dataCensored)

# retrieve all corrected chlorophyll-a concentrations for Station CB5.4,
# missing values are removed and transformation applied. Note, a 
# warning is displayed indicating that data set has layers but user did
# not specify layer in retrieval. layerAggregation then aggregates per 
# specifications
dfr2   <- selectData(dfr[["df"]], 'chla', 'CB5.4', analySpec=dfr[["analySpec"]])
df2    <- dfr2[[1]]   # data frame of selected data
iSpec2 <- dfr2[[2]]   # meta data about selected data
df2a   <- layerAggregation(df2, avgTechnique="mean", layerAggOption=4)
}

}
