% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerBatch.R
\name{OptimizerBatch}
\alias{OptimizerBatch}
\title{Batch Optimizer}
\description{
Abstract \code{OptimizerBatch} class that implements the base functionality each \code{OptimizerBatch} subclass must provide.
A \code{OptimizerBatch} object describes the optimization strategy.
A \code{OptimizerBatch} object must write its result to the \verb{$assign_result()} method of the \link{OptimInstance} at the end in order to store the best point and its estimated performance vector.
}
\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\seealso{
\link{OptimizerBatchDesignPoints}, \link{OptimizerBatchGridSearch}, \link{OptimizerBatchRandomSearch}
}
\section{Super class}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{OptimizerBatch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerBatch-optimize}{\code{OptimizerBatch$optimize()}}
\item \href{#method-OptimizerBatch-clone}{\code{OptimizerBatch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="initialize"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-initialize'><code>bbotk::Optimizer$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatch-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatch-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the optimization and writes optimization result into \link{OptimInstanceBatch}.
The optimization result is returned but the complete optimization path is stored in \link{ArchiveBatch} of \link{OptimInstanceBatch}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatch$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{OptimInstanceBatch}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
