% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_models.R
\name{best_models}
\alias{best_models}
\title{Table with the best models according to one of the posterior criteria}
\usage{
best_models(
  bma_list,
  criterion = 1,
  best = 5,
  app = 3,
  estimate = TRUE,
  robust = TRUE
)
}
\arguments{
\item{bma_list}{bma object (the result of the bma function)}

\item{criterion}{The criterion that will be used for a basis of the model ranking: \cr
1 - binomial model prior \cr
2 - binomial-beta model prior}

\item{best}{The number of the best models to be considered}

\item{app}{Parameter indicating the decimal place to which number in the tables should be rounded (default app = 3)}

\item{estimate}{A parameter with values TRUE or FALSE indicating which table should be displayed when
the function finishes calculations. Works well when best is small.\cr
TRUE - table with estimation to the results \cr
FALSE - table with the inclusion of regressors in the best models}

\item{robust}{A parameter with values TRUE or FALSE indicating which type of stanrdard errors should be displayed
when the function finishes calculations. Works only if estimate = TRUE. Works well when best is small.\cr
TRUE - robust standard errors \cr
FALSE - regular standard errors}
}
\value{
A list with best_models objects: \cr
\enumerate{
\item matrix with inclusion of the regressors in the best models \cr
\item matrix with estimation output in the best models with regular standard errors \cr
\item matrix with estimation output in the best models with robust standard errors \cr
\item knitr_kable table with inclusion of the regressors in the best models (the best for the display on the console - up to 11 models) \cr
\item knitr_kable table with estimation output in the best models with regular standard errors (the best for the display on the console - up to 6 models) \cr
\item knitr_kable table with estimation output in the best models with robust standard errors (the best for the display on the console - up to 6 models) \cr
\item gTree table with inclusion of the regressors in the best models (displayed as a plot). Use grid::grid.draw() to display.\cr
\item gTree table with estimation output in the best models with regular standard errors (displayed as a plot). Use grid::grid.draw() to display.
\item gTree table with estimation output in the best models with robust standard errors (displayed as a plot). Use grid::grid.draw() to display.
}
}
\description{
This function creates a ranking of best models according to one of the possible criterion (PMP under binomial model prior, PMP under binomial-beta model prior, R^2 under binomial model prior, R^2 under binomial-beta model prior).
The function gives two types of tables in three different formats: inclusion table (where 1 indicates presence of the regressor in the model and 0 indicates that the variable is excluded from the model) and estimation results table (it displays the best models and estimation output for those models: point estimates, standard errors, significance level, and R^2).
}
\examples{
\donttest{
library(magrittr)

data_prepared <- economic_growth[,1:7] \%>\%
   feature_standardization(timestamp_col = year, entity_col = country) \%>\%
   feature_standardization(timestamp_col = year, entity_col = country,
                           time_effects = TRUE, scale = FALSE)

model_space <- optimal_model_space(df = data_prepared, dep_var_col = gdp,
                                   timestamp_col = year, entity_col = country,
                                   init_value = 0.5)

bma_results <- bma(df = data_prepared, dep_var_col = gdp, timestamp_col = year,
entity_col = country, model_space = model_space, run_parallel = FALSE, dilution = 0)

best_5_models <- best_models(bma_results, criterion = 1, best = 5, estimate = TRUE, robust = TRUE)
}
}
