% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-middleware.R
\name{handleErrors}
\alias{handleErrors}
\title{Error-handling middleware}
\usage{
handleErrors(beakr = NULL)
}
\arguments{
\item{beakr}{Beakr instance}
}
\value{
A \code{Beakr} instance with added middleware.
}
\description{
This default error handler should be added
at the end of the beakr pipeline, right before \code{listen()}. Errors
generated by any previous step will be returned within a JSON wrapper.

The general structure for a stand-alone executable script with a
\pkg{beakr} webservice typically looks like this:

\preformatted{
newBeakr() %>%

  httpGET(<route_A>, function(req, res, err) {
    ...
  }) %>%

  httpGET(<route_B>, function(req, res, err) {
    ...
  }) %>%

  serveStaticFiles(...) %>%

  handleErrors() %>%

  listen()
}
}
