% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncMessage.R
\name{truncMessage}
\alias{truncMessage}
\title{truncate message parts}
\usage{
truncMessage(x, ntrunc = 3, prefix = "s", midfix = " ", altnix = "'")
}
\arguments{
\item{x}{Character vector}

\item{ntrunc}{Integer: number of elements printed before truncation. DEFAULT: 3}

\item{prefix}{Character: Prefix added if \code{length(x)>1}. DEFAULT: "s"}

\item{midfix}{Character: string added after prefix OR before first altnix. DEFAULT: " "}

\item{altnix}{Character: Alternative string padded around x if \code{length(x)==1}. 
DEFAULT: "'"}
}
\value{
Character string
}
\description{
truncate long vectors for messages
}
\examples{
truncMessage("hi")
message("listing name", truncMessage(       "hi"      ), ".")
message("listing name", truncMessage(paste0("hi",1:10)), ".")
truncMessage(paste0("hi",1:10), ntrunc=1)
truncMessage(paste0("hi",1:10), ntrunc=2, prefix="", midfix="")
truncMessage(paste0("hi",1:10), ntrunc=8, prefix="files _ ")

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Nov 2016
}
\seealso{
\code{\link{message}}
}
\keyword{character}

