% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{LL.CA}
\alias{LL.CA}
\title{An Implementation of the Livingston and Lewis (1995) Approach to Estimate Classification Accuracy based on Observed Test Scores and Test Reliability.}
\usage{
LL.CA(x = NULL, reliability, cut, min = 0, max = 1,
  error.model = "binomial", truecut = NULL, grainsize = 0.001)
}
\arguments{
\item{x}{A vector of observed scores for which a beta-distribution is to be fitted.}

\item{reliability}{The observed-score squared correlation with the true-score.}

\item{cut}{The cutoff value for classifying observations into pass or fail categories.}

\item{min}{The minimum value possible to attain on the test. Default is 0 (assuming \code{x} represent proportions).}

\item{max}{The maximum value possible to attain on the test. Default is 1 (assuming \code{x} represent proportions).}

\item{error.model}{The probability distribution to be used for producing the sampling distributions at different points of the true-score scale. Options are \code{beta} and \code{binomial}. The binomial distribution is discrete, and is the distribution used originally by Livingston and Lewis. Use of the binomial distribution involves a rounding of the effective test length to the nearest integer value. The Beta distribution is continuous, and does not involve rounding of the effective test length..}

\item{truecut}{Optional specification of a "true" cutoff. Useful for producing ROC curves.}

\item{grainsize}{The size of the steps for which probabilities along the score distribution are to be calculated. Default is .001 (1001 points).}
}
\value{
A list containing the estimated parameters necessary for the approach, as well as the confusion matrix estimating the proportion of true/false pass/fail categorizations for a test, given a specific distribution of observed scores.
}
\description{
An implementation of what has been come to be known as the "Livingston and Lewis approach" to classification accuracy, which by employing a compound beta-binomial distribution assumes that true-scores conform to four-parameter beta distributions, and errors of measurement binomial distribution distribution. Under these assumptions, the expected classification consistency and accuracy of tests can be estimated from observed outcomes and test reliability.
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, .25, .75, 5, 3))
hist(testdata, xlim = c(0, 100))

# Suppose the cutoff value for attaining a pass is 50 items correct, and
# that the reliability of this test was estimated to 0.7. To estimate and
# retrieve the necessary parameters and the confusion matrix with LL.CA():
LL.CA(x = testdata, reliability = .7, cut = 50, min = 0, max = 100)
}
\references{
Livingston, Samuel A. and Lewis, Charles. (1995). Estimating the Consistency and Accuracy of Classifications Based on Test Scores. Journal of Educational Measurement, 32(2).
}
