% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_betaselect_methods.R
\name{summary.glm_betaselect}
\alias{summary.glm_betaselect}
\alias{print.summary.glm_betaselect}
\title{Summary of an
'glm_betaselect'-Class Object}
\usage{
\method{summary}{glm_betaselect}(
  object,
  dispersion = NULL,
  correlation = FALSE,
  symbolic.cor = FALSE,
  trace = FALSE,
  test = c("LRT", "Rao"),
  se_method = c("boot", "bootstrap", "z", "glm", "default"),
  ci = TRUE,
  level = 0.95,
  boot_type = c("perc", "bc"),
  boot_pvalue_type = c("asymmetric", "norm"),
  type = c("beta", "standardized", "raw", "unstandardized"),
  print_raw = c("none", "before_ci", "after_ci"),
  transform_b = NULL,
  transform_b_name = NULL,
  ...
)

\method{print}{summary.glm_betaselect}(
  x,
  est_digits = 3,
  symbolic.cor = x$symbolic.cor,
  signif.stars = getOption("show.signif.stars"),
  show.residuals = FALSE,
  z_digits = 3,
  pvalue_less_than = 0.001,
  ...
)
}
\arguments{
\item{object}{The output of
\code{\link[=glm_betaselect]{glm_betaselect()}}.}

\item{dispersion}{The dispersion
parameter. If \code{NULL}, then it is
extracted from the object. If
a scalar, it will be used as
the dispersion parameter. See
\code{\link[stats:summary.glm]{stats::summary.glm()}} for details.}

\item{correlation}{If \code{TRUE}, the
correlation matrix of the estimates
will be returned. The same argument
in \code{\link[stats:summary.glm]{stats::summary.glm()}}. Default
is \code{FALSE}.}

\item{symbolic.cor}{If \code{TRUE},
correlations are printed in symbolic
form as in \code{\link[stats:summary.glm]{stats::summary.glm()}}.
Default is \code{FALSE}.}

\item{trace}{Logical. Whether
profiling will be traced when forming
the confidence interval if
\code{se_method} is \code{"default"}, \code{"z"}, or
\code{"glm"}. Ignored if \code{ci} is \code{FALSE}.
See \code{\link[stats:confint]{stats::confint.glm()}} for
details.}

\item{test}{The test used for
\code{se_method} is \code{"default"}, \code{"z"}, or
\code{"glm"}. Ignored if \code{ci} is \code{FALSE}.
See \code{\link[stats:confint]{stats::confint.glm()}} for
details.}

\item{se_method}{The method used to
compute the standard errors and
confidence intervals (if requested).
If bootstrapping was
requested when calling
\code{\link[=glm_betaselect]{glm_betaselect()}} and this argument
is set to \code{"bootstrap"} or \code{"boot"},
the bootstrap standard errors are
returned. If bootstrapping
was not requested or if this argument
is set to \code{"z"}, \code{"glm"}, or \code{"default"},
then the usual \code{glm}
standard errors are
returned.
Default is \code{"boot"}.}

\item{ci}{Logical. Whether
confidence intervals are computed.
Default is \code{FALSE.}}

\item{level}{The level of confidence,
default is .95, returning the 95\%
confidence interval.}

\item{boot_type}{The type of
bootstrap confidence intervals,
if requested.
Currently, it supports \code{"perc"},
percentile bootstrap confidence
intervals, and \code{"bc"}, bias-corrected
bootstrap confidence interval.}

\item{boot_pvalue_type}{The type
of \emph{p}-values if \code{se_method} is
\code{"boot"} or \code{"bootstrap"}. If \code{"norm"},
then the \emph{z} score is used to compute
the \emph{p}-value using a
standard normal distribution.
If \code{"asymmetric"}, the default, then
the method presented in
Asparouhov and Muthén (2021) is used
to compute the \emph{p}-value based on the
bootstrap distribution.}

\item{type}{String. If
\code{"unstandardized"} or \code{"raw"}, the
output \emph{before} standardization
are used If \code{"beta"} or
\code{"standardized"}, then the
output \emph{after} selected
variables standardized are returned.
Default is \code{"beta"}.}

\item{print_raw}{Control whether
the estimates before selected
standardization are printed when
\code{type} is \code{"beta"} or \code{"standardized"}.
If \code{"none"}, the default, then it
will not be printed. If set to \code{"before_ci"}
and \code{ci} is \code{TRUE}, then will be
inserted to the left of the confidence
intervals. If set to "after_ci"\code{and}ci\code{is}TRUE\verb{, then will be printed to the right of the confidence intervals. If }ci\code{is}FALSE`, then will
be printed to the right of the
standardized estimates.}

\item{transform_b}{The function
to be used to transform the
confidence limits. For example,
if set to \code{exp}, the confidence
limits will be exponentiated. Users
need to decide whether the transformed
limits are meaningful. Default is
\code{NULL}.}

\item{transform_b_name}{If
\code{transform_b} is a function, then
this is the name of the transformed
coefficients. Default is
\code{"Estimate(Transformed)"}}

\item{...}{Additional arguments
passed to other methods.}

\item{x}{The output of
\code{\link[=summary.glm_betaselect]{summary.glm_betaselect()}}.}

\item{est_digits}{The number of
digits after the decimal to be
displayed for the coefficient
estimates, their standard errors, and
confidence intervals (if present).
Note that the values will be rounded
to this number of digits before
printing. If all digits at this
position are zero for all values, the
values may be displayed with fewer
digits. Note that the coefficient
table is printed by
\code{\link[stats:printCoefmat]{stats::printCoefmat()}}. If some
numbers are vary large, the number of
digits after the decimal may be
smaller than \code{est_digits} due to a
limit on the column width.}

\item{signif.stars}{Whether "stars"
(asterisks) are printed to denote
the level of significance achieved
for each coefficient. Default is
\code{TRUE}.}

\item{show.residuals}{If \code{TRUE},
a summary of the deviance residuals
will be printed. Default is \code{FALSE}.}

\item{z_digits}{The number of digits
after the decimal to be displayed for
the \emph{z} or similar statistic (in the
column \code{"z value"}).}

\item{pvalue_less_than}{If a
\emph{p}-value is less than this value, it
will be displayed with \verb{"<(this value)".} For example, if
\code{pvalue_less_than} is .001, the
default, \emph{p}-values less than .001
will be displayed as \verb{<.001}. This
value also determines the printout of
the \emph{p}-value of the \emph{F} statistic.
(This argument does what \code{eps.Pvalue}
does in \code{\link[stats:printCoefmat]{stats::printCoefmat()}}.)}
}
\value{
It returns an object of class
\code{summary.glm_betaselect}, which is
similar to the output of
\code{\link[stats:summary.glm]{stats::summary.glm()}}, with additional
information on the standardization
and bootstrapping, if requested.

The \code{print}-method of
\code{summary.glm_betaselect} is called
for its side effect. The object \code{x}
is returned invisibly.
}
\description{
The \code{summary} method
for \code{glm_betaselect}-class objects.
}
\details{
By default, it returns a
\code{summary.glm_betaselect}-class object
for the results with selected variables
standardized. By setting \code{type} to
\code{"raw"} or \code{"unstandardized"}, it
returns the summary for the results
\emph{before} standardization.

The \code{print} method of
\code{summary.glm_betaselect}-class objects
is adapted from
\code{\link[stdmod:print.summary.std_selected]{stdmod::print.summary.std_selected()}}.
}
\examples{

data_test_mod_cat$p <- scale(data_test_mod_cat$dv)[, 1]
data_test_mod_cat$p <- ifelse(data_test_mod_cat$p > 0,
                              yes = 1,
                              no = 0)
# bootstrap should be set to 2000 or 5000 in real studies
logistic_beta_x <- glm_betaselect(p ~ iv*mod + cov1 + cat1,
                                  data = data_test_mod_cat,
                                  family = binomial,
                                  to_standardize = "iv",
                                  do_boot = TRUE,
                                  bootstrap = 100,
                                  iseed = 1234)
summary(logistic_beta_x)

}
\references{
Asparouhov, A., & Muthén, B. (2021). Bootstrap p-value computation.
Retrieved from https://www.statmodel.com/download/FAQ-Bootstrap\%20-\%20Pvalue.pdf
}
\seealso{
\code{\link[=glm_betaselect]{glm_betaselect()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
