% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicWhittle_prior_and_mcmc_params.R
\name{bdp_dw_prior_params_gen}
\alias{bdp_dw_prior_params_gen}
\title{Generate a list of parameter values in prior elicitation}
\usage{
bdp_dw_prior_params_gen(
  M = 1,
  g0.alpha = 1,
  g0.beta = 1,
  k1.theta = 0.01,
  k2.theta = 0.01,
  tau.alpha = 0.001,
  tau.beta = 0.001,
  k1max = 100,
  k2max = 100,
  L = 20,
  bernstein1_l = 0.1,
  bernstein1_r = 0.9,
  bernstein2_l = 0.1,
  bernstein2_r = 0.9
)
}
\arguments{
\item{M}{DP base measure constant (> 0)}

\item{g0.alpha, g0.beta}{parameters of Beta base measure of DP}

\item{k1.theta}{prior parameter for polynomial corresponding to rescaled time (propto exp(-k1.theta*k1*log(k1)))}

\item{k2.theta}{prior parameter for polynomial corresponding to rescaled frequency (propto exp(-k2.theta*k2*log(k2)))}

\item{tau.alpha, tau.beta}{prior parameters for tau (inverse gamma)}

\item{k1max}{upper bound of the degrees of Bernstein polynomial
corresponding to rescaled time (for pre-computation of basis functions)}

\item{k2max}{upper bound of the degrees of Bernstein polynomial
corresponding to rescaled frequency (for pre-computation of basis functions)}

\item{L}{truncation parameter of DP in stick breaking representation}

\item{bernstein1_l, bernstein1_r}{left and right truncation of Bernstein polynomial basis functions
for rescaled time, 0<=bernstein1_l<bernstein1_r<=1}

\item{bernstein2_l, bernstein2_r}{left and right truncation of Bernstein polynomial basis functions
for rescaled frequency, 0<=bernstein2_l<bernstein2_r<=1}
}
\value{
A list of prior parameter values
}
\description{
Generate a list of parameter values in prior elicitation
}
