% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tree_eco.R
\name{plot_tree_eco}
\alias{plot_tree_eco}
\title{Plot tree for a given tree ECO table}
\usage{
plot_tree_eco(tr, main = "", add.lines = T, add.labels = T)
}
\arguments{
\item{tr}{data frame containg tree ECO}

\item{main}{string for main title, default is ""}

\item{add.lines}{boolean (default TRUE) add weighted mean lines?}

\item{add.labels}{boolean (default TRUE) add labels?}
}
\value{
Barplot with white scores, draws percent and black scores.
}
\description{
Plot tree (barplot percentages) for a given tree ECO data frame.
}
\examples{
f <- system.file("extdata", "Kasparov.gz", package = "bigchess")
con <- gzfile(f,encoding = "latin1")
df <- read.pgn(con,quiet = TRUE,stat.moves = FALSE, add.tags = "ECO")
tr <- tree_eco(subset(df,W1=="e4"),20)
plot_tree_eco(tr,"1. e4 ... ?")
}
