% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/man-qq-gc.R
\name{snp_qq}
\alias{snp_qq}
\title{Q-Q plot}
\usage{
snp_qq(gwas, lambdaGC = TRUE, coeff = 1)
}
\arguments{
\item{gwas}{A \code{mhtest} object with the p-values associated with each SNP.
Typically, the output of \link{big_univLinReg}, \link{big_univLogReg} or \link{snp_pcadapt}.}

\item{lambdaGC}{Add the Genomic Control coefficient as subtitle to the plot?}

\item{coeff}{Relative size of text. Default is \code{1}.}
}
\value{
A \code{ggplot2} object. You can plot it using the \code{print} method.
You can modify it as you wish by adding layers. You might want to read
\href{http://r4ds.had.co.nz/data-visualisation.html}{this chapter}
to get more familiar with the package \strong{ggplot2}.
}
\description{
Creates a quantile-quantile plot from p-values from a GWAS study.
}
\examples{
set.seed(9)

test <- snp_attachExtdata()
G <- test$genotypes
y <- rnorm(nrow(G))

gwas <- big_univLinReg(G, y)
snp_qq(gwas)
gwas_gc <- snp_gc(gwas) # change attr(gwas_gc, "transfo")

snp_qq(gwas_gc)
# The next plot should be prettier with a real dataset
snp_manhattan(gwas_gc,
              infos.chr = test$map$chromosome,
              infos.pos = test$map$physical.pos)

p <- snp_qq(gwas_gc) + ggplot2::aes(text = asPlotlyText(test$map))
\dontrun{plotly::ggplotly(p, tooltip = "text")}
}
