% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectPCA-bed.R
\name{bed_projectSelfPCA}
\alias{bed_projectSelfPCA}
\title{Projecting PCA}
\usage{
bed_projectSelfPCA(
  obj.svd,
  obj.bed,
  ind.row,
  ind.col = attr(obj.svd, "subset"),
  ncores = 1
)
}
\arguments{
\item{obj.svd}{List with \code{v}, \code{d}, \code{center} and \code{scale}. Typically the an
object of type "big_SVD".}

\item{obj.bed}{Object of type bed, which is the mapping of the bed file of
the data containing both the individuals that were used to compute the PCA
and the other individuals to be projected.}

\item{ind.row}{Rows (individuals) to be projected.}

\item{ind.col}{Columns that were used for computing PCA. If \link{bed_autoSVD} was
used, then \code{attr(obj.svd, "subset")} is automatically used by default.
Otherwise (e.g. if \link{bed_randomSVD} was used), you have to pass \code{ind.col}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link[bigstatsr]{nb_cores}.}
}
\value{
A list of 3 elements:
\itemize{
\item \verb{$obj.svd.ref}: big_SVD object computed from reference data.
\item \verb{$simple_proj}: simple projection of new data into space of reference PCA.
\item \verb{$OADP_proj}: Online Augmentation, Decomposition, and Procrustes (OADP)
projection of new data into space of reference PCA.
}
}
\description{
Projecting PCA using individuals from one dataset
to other individuals from the same dataset.
}
