% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCT.R
\name{SCT}
\alias{SCT}
\alias{snp_grid_clumping}
\alias{snp_grid_PRS}
\alias{snp_grid_stacking}
\title{Stacked C+T (SCT)}
\usage{
snp_grid_clumping(
  G,
  infos.chr,
  infos.pos,
  lpS,
  ind.row = rows_along(G),
  grid.thr.r2 = c(0.01, 0.05, 0.1, 0.2, 0.5, 0.8, 0.95),
  grid.base.size = c(50, 100, 200, 500),
  infos.imp = rep(1, ncol(G)),
  grid.thr.imp = 1,
  groups = list(cols_along(G)),
  exclude = NULL,
  ncores = 1
)

snp_grid_PRS(
  G,
  all_keep,
  betas,
  lpS,
  n_thr_lpS = 50,
  grid.lpS.thr = 0.9999 * seq_log(max(0.1, min(lpS)), max(lpS), n_thr_lpS),
  ind.row = rows_along(G),
  backingfile = tempfile(),
  type = c("float", "double"),
  ncores = 1
)

snp_grid_stacking(
  multi_PRS,
  y.train,
  alphas = c(1, 0.01, 1e-04),
  ncores = 1,
  ...
)
}
\arguments{
\item{G}{A \link[=FBM.code256-class]{FBM.code256}
(typically \verb{<bigSNP>$genotypes}).\cr
\strong{You shouldn't have missing values.} Also, remember to do quality control,
e.g. some algorithms in this package won't work if you use SNPs with 0 MAF.}

\item{infos.chr}{Vector of integers specifying each SNP's chromosome.\cr
Typically \verb{<bigSNP>$map$chromosome}.}

\item{infos.pos}{Vector of integers specifying the physical position
on a chromosome (in base pairs) of each SNP.\cr
Typically \verb{<bigSNP>$map$physical.pos}.}

\item{lpS}{Numeric vector of \code{-log10(p-value)} associated with \code{betas}.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{grid.thr.r2}{Grid of thresholds over the squared correlation between
two SNPs for clumping. Default is \code{c(0.01, 0.05, 0.1, 0.2, 0.5, 0.8, 0.95)}.}

\item{grid.base.size}{Grid for base window sizes. Sizes are then computed as
\code{base.size / thr.r2} (in kb). Default is \code{c(50, 100, 200, 500)}.}

\item{infos.imp}{Vector of imputation scores. Default is all \code{1} if you do
not provide it.}

\item{grid.thr.imp}{Grid of thresholds over \code{infos.imp} (default is \code{1}), but
you should change it (e.g. \code{c(0.3, 0.6, 0.9, 0.95)}) if providing \code{infos.imp}.}

\item{groups}{List of vectors of indices to define your own categories.
This could be used e.g. to derive C+T scores using two different GWAS
summary statistics, or to include other information such as functional
annotations. Default just makes one group with all variants.}

\item{exclude}{Vector of SNP indices to exclude anyway.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{all_keep}{Output of \code{snp_grid_clumping()} (indices passing clumping).}

\item{betas}{Numeric vector of weights (effect sizes from GWAS) associated
with each variant (column of \code{G}). If alleles are reversed, make sure to
multiply corresponding effects by \code{-1}.}

\item{n_thr_lpS}{Length for default \code{grid.lpS.thr}. Default is \code{50}.}

\item{grid.lpS.thr}{Sequence of thresholds to apply on \code{lpS}.
Default is a grid (of length \code{n_thr_lpS}) evenly spaced on a logarithmic
scale, i.e. on a log-log scale for p-values.}

\item{backingfile}{Prefix for backingfiles where to store scores of C+T.
As we typically use a large grid, this can result in a large matrix so that
we store it on disk. Default uses a temporary file.}

\item{type}{Type of backingfile values. Either \code{"float"} (the default) or
\code{"double"}. Using \code{"float"} requires half disk space.}

\item{multi_PRS}{Output of \code{snp_grid_PRS()}.}

\item{y.train}{Vector of phenotypes. If there are two levels (binary 0/1),
it uses \code{\link[=big_spLogReg]{big_spLogReg()}} for stacking, otherwise \code{\link[=big_spLinReg]{big_spLinReg()}}.}

\item{alphas}{Vector of values for grid-search. See \code{\link[=big_spLogReg]{big_spLogReg()}}.
Default for this function is \code{c(1, 0.01, 0.0001)}.}

\item{...}{Other parameters to be passed to \code{\link[=big_spLogReg]{big_spLogReg()}}. For example,
using \code{covar.train}, you can add covariates in the model with all C+T scores.
You can also use \code{pf.covar} if you do not want to penalize these covariates.}
}
\value{
\code{snp_grid_PRS()}: An \code{FBM} (matrix on disk) that stores the C+T scores
for all parameters of the grid (and for each chromosome separately).
It also stores as attributes the input parameters \code{all_keep}, \code{betas},
\code{lpS} and \code{grid.lpS.thr} that are also needed in \code{snp_grid_stacking()}.
}
\description{
Polygenic Risk Scores for a grid of clumping and thresholding parameters.

Stacking over many Polygenic Risk Scores, corresponding to a grid of many
different parameters for clumping and thresholding.
}
