% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed-tcrossprodSelf.R
\name{bed_tcrossprodSelf}
\alias{bed_tcrossprodSelf}
\title{Tcrossprod}
\usage{
bed_tcrossprodSelf(
  obj.bed,
  fun.scaling = bed_scaleBinom,
  ind.row = rows_along(obj.bed),
  ind.col = cols_along(obj.bed),
  block.size = block_size(length(ind.row))
)
}
\arguments{
\item{obj.bed}{Object of type \code{bed}, which is the mapping of some bed file.
Use \code{obj.bed <- bed(bedfile)} to get this object.}

\item{fun.scaling}{A function that returns a named list of
\code{mean} and \code{sd} for every column, to scale each of their elements
such as followed: \deqn{\frac{X_{i,j} - mean_j}{sd_j}.}
Default doesn't use any scaling.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{block.size}{Maximum number of columns read at once.
Default uses \link[bigstatsr]{block_size}.}
}
\value{
A temporary \link[bigstatsr:FBM-class]{FBM}, with the following two attributes:
\itemize{
\item a numeric vector \code{center} of column scaling,
\item a numeric vector \code{scale} of column scaling.
}
}
\description{
Compute \eqn{X.row X.row^T} for a Filebacked Big Matrix \code{X}
after applying a particular scaling to it.
}
\examples{
bedfile <- system.file("extdata", "example.bed", package = "bigsnpr")
obj.bed <- bed(bedfile)

K <- bed_tcrossprodSelf(obj.bed)
K[1:4, 1:6] / ncol(obj.bed)

}
