% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom-scaling.R
\name{snp_scaleBinom}
\alias{snp_scaleBinom}
\title{Binomial(n, p) scaling}
\usage{
snp_scaleBinom(nploidy = 2)
}
\arguments{
\item{nploidy}{Number of trials, parameter of the binomial distribution.
Default is \code{2}, which corresponds to diploidy, such as for the human genome.}
}
\value{
A new \strong{function} that returns a data.frame of two vectors
"center" and "scale" which are of the length of \code{ind.col}.
}
\description{
Binomial(n, p) scaling where \code{n} is fixed and \code{p} is estimated.
}
\details{
You will probably not use this function as is but as the
\code{fun.scaling} parameter of other functions of package \code{bigstatsr}.
}
\examples{
set.seed(1)

a <- matrix(0, 93, 170)
p <- 0.2
a[] <- rbinom(length(a), 2, p)
X <- add_code256(big_copy(a, type = "raw"), code = c(0, 1, 2, rep(NA, 253)))
X.svd <- big_SVD(X, fun.scaling = snp_scaleBinom())
str(X.svd)
plot(X.svd$center)
abline(h = 2 * p, col = "red")
plot(X.svd$scale)
abline(h = sqrt(2 * p * (1 - p)), col = "red")
}
\references{
This scaling is widely used for SNP arrays.
Patterson N, Price AL, Reich D (2006). Population Structure and Eigenanalysis.
PLoS Genet 2(12): e190. \doi{10.1371/journal.pgen.0020190}.
}
