% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SFBM.R
\docType{class}
\name{SFBM_corr_compact-class}
\alias{SFBM_corr_compact-class}
\alias{SFBM_corr_compact_RC}
\alias{as_SFBM_corr_compact}
\title{Class SFBM_corr_compact}
\usage{
as_SFBM_corr_compact(spmat, backingfile = tempfile())
}
\arguments{
\item{spmat}{A 'dgCMatrix' (non-symmetric sparse matrix of type 'double')
or 'dsCMatrix' (symmetric sparse matrix of type 'double').}

\item{backingfile}{Path to file where to store data. Extension \code{.sbk} is
automatically added.}
}
\value{
The new \link[=SFBM_corr_compact-class]{SFBM_corr_compact}.
}
\description{
A reference class for storing and accessing from disk a sparse correlation
matrix where non-zero values in columns are mostly contiguous. It rounds
correlation values with precision 1/32767 to store them using 2 bytes only.
This class has been specifically designed for package 'bigsnpr'.

Convert a 'dgCMatrix' or 'dsCMatrix' to an SFBM_corr_compact.
}
\details{
It inherits the fields and methods from class \link[=SFBM-class]{SFBM_compact}.
}

\examples{
spmat2 <- as(cor(iris[1:4]), "dsCMatrix")
(X2 <- as_SFBM_corr_compact(spmat2))
(bin <- readBin(X2$sbk, what = integer(), size = 2, n = 100))
matrix(bin / 32767, 4)
spmat2

}
