% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crochet.R
\name{Replace}
\alias{Replace}
\title{Create an Implementation of [<- For Custom Matrix-Like Types}
\usage{
Replace(replace_vector, replace_matrix)
}
\arguments{
\item{replace_vector}{A function in the form of \verb{function(x, i, value)}
that replaces a vector subset of \code{x} based on a single vector of indices \code{i}
with the values in \code{value} and returns \code{x}, invisibly.}

\item{replace_matrix}{A function in the form of \verb{function(x, i, j, value)}
that replaces a matrix subset of \code{x} based on two vectors of indices \code{i} and
\code{j} with the values in \code{value} and returns \code{x}, invisibly.}
}
\value{
A function in the form of \verb{function(x, i, j, ..., value)} that is
meant to be used as a method for \verb{[<-} for a custom type.
}
\description{
\code{replace} is a function that converts different index types such as negative
integer vectors or logical vectors passed to the \verb{[<-} function as \code{i}
(e.g. \code{X[i]}) or \code{i} and \code{j} (e.g. \code{X[i, j]}) into positive
integer vectors. The converted indices are provided as the \code{i} parameter of
\code{replace_vector} or \code{i} and \code{j} parameters of \code{replace_matrix} to facilitate
implementing the replacement mechanism for custom matrix-like types.
Single values are recycled to match the replacement length.
}
\details{
\strong{This idea initially comes from \href{https://goo.gl/3RDNQG}{package crochet}.}
}
\keyword{internal}
