% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-write.R
\name{big_write}
\alias{big_write}
\title{Write an FBM to a file}
\usage{
big_write(
  X,
  file,
  every_nrow,
  ...,
  ind.row = rows_along(X),
  ind.col = cols_along(X),
  progress = FALSE
)
}
\arguments{
\item{X}{An object of class \link[=FBM-class]{FBM}.}

\item{file}{File to write to.}

\item{every_nrow}{Number of rows to write at once.}

\item{...}{Other arguments to be passed to \link[data.table:fwrite]{data.table::fwrite},
except \code{x}, \code{file}, \code{append}, \code{row.names}, \code{col.names} and \code{showProgress}.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{progress}{Show progress? Default is \code{FALSE}.}
}
\value{
Input parameter \code{file}, invisibly.
}
\description{
Write a file from a Filebacked Big Matrix (by parts).
}
\examples{
X <- big_attachExtdata()
csv <- big_write(X, tempfile(), every_nrow = 100, progress = interactive())

}
