% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.mhtest}
\alias{plot.mhtest}
\title{Plot method}
\usage{
\method{plot}{mhtest}(x, type = c("hist", "Manhattan", "Q-Q", "Volcano"), coeff = 1, ...)
}
\arguments{
\item{x}{An object of class \code{mhtest}.}

\item{type}{Either.
\itemize{
\item "hist": histogram of p-values (the default).
\item "Manhattan": plot of the negative logarithm (in base 10) of p-values.
\item "Q-Q": Q-Q plot.
\item "Volcaco": plot of the negative logarithm of p-values against the
estimation of coefficients (e.g. betas in linear regression)
}}

\item{coeff}{Relative size of text. Default is \code{1}.}

\item{...}{Not used.}
}
\value{
A \code{ggplot2} object. You can plot it using the \code{print} method.
You can modify it as you wish by adding layers. You might want to read
\href{https://r4ds.had.co.nz/data-visualisation.html}{this chapter}
to get more familiar with the package \strong{ggplot2}.
}
\description{
Plot method for class \code{mhtest}.
}
\examples{
set.seed(1)

X <- big_attachExtdata()
y <- rnorm(nrow(X))
test <- big_univLinReg(X, y)

plot(test)
plot(test, type = "Volcano")
plot(test, type = "Q-Q")
plot(test, type = "Manhattan")
plot(test, type = "Manhattan") + ggplot2::ggtitle(NULL)

}
\seealso{
\link{big_univLinReg}, \link{big_univLogReg},
\link{plot.big_SVD} and \link{asPlotlyText}.
}
