% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier-hist.R
\name{pca_nspike}
\alias{pca_nspike}
\title{Number of spikes in PCA}
\usage{
pca_nspike(eigval, breaks = "FD", nboot = 100)
}
\arguments{
\item{eigval}{Eigenvalues (squared singular values).}

\item{breaks}{Same parameter as for \code{hist()}. Default uses a robust version
of Scott's rule. You can also use \code{"FD"} or \code{nclass.FD} for a bit more bins.}

\item{nboot}{Number of bootstrap replicates to estimate limits more robustly.
Default is \code{100}.}
}
\value{
The estimated number of distant spikes.
}
\description{
Estimate the number of distant spikes based on the histogram of eigenvalues.
}
\examples{
N <- 400; M <- 2000; K <- 8
U <- matrix(0, N, K); U[] <- rnorm(length(U))
V <- matrix(0, M, K); V[] <- rnorm(length(V))
# X = U V^T + E
X <- tcrossprod(U, V) + 15 * rnorm(N * M)
pca <- prcomp(X)
eigval <- pca$sdev^2
plot(head(eigval, -1), log = "xy", pch = 20)
pca_nspike(eigval)

}
