% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billboard-mapping.R
\name{billboard-aes}
\alias{billboard-aes}
\alias{bb_aes}
\alias{bb_aes_string}
\alias{bbaes}
\alias{bbaes_string}
\title{Map variables on the chart}
\usage{
bb_aes(bb, x, y, group = NULL)

bb_aes_string(bb, x, y, group = NULL)

bbaes(x, y, group = NULL)

bbaes_string(x, y, group = NULL)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{x}{Name of the variable to map on the x-axis.}

\item{y}{Name of the variable to map on the y-axis.}

\item{group}{Name of the grouping variable.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Map variables on the chart
}
\note{
\code{bb_aes} is intended to use in a "piping" way. 
\code{bbaes} is the equivalent to use inside a helper function
 such as \code{bb_barchart}, \code{bb_scatterplot}...
}
\examples{
\dontrun{
dat <- as.data.frame(table(sample(letters[1:5], 100, TRUE)))

billboarder(data = dat) \%>\% 
  bb_aes(x = Var1, y = Freq) \%>\% 
  bb_barchart()


tab <- table(sample(letters[1:5], 100, TRUE), sample(LETTERS[1:5], 100, TRUE))
dat_group <- as.data.frame(tab)

billboarder(data = dat_group) \%>\% 
  bb_aes(x = Var1, y = Freq, group = "Var2") \%>\% 
  bb_barchart()
}
}
