% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step2.5_rev_e.R
\name{rev_e}
\alias{rev_e}
\title{Review Experimental Effect}
\usage{
rev_e(data, result, model, model_name, param_prefix, n_trials)
}
\arguments{
\item{data}{[data.frame]
Raw data. Must include the following columns:  
 - `"sub"`: Subject ID  
 - `"time_line"`: Trial index  
 - `"L_choice"` / `"R_choice"`: Left and right choice identifiers  
 - `"L_reward"` / `"R_reward"`: Left and right reward values}

\item{result}{[data.frame]
Output data generated by the `fit_p()` function. Each row represents 
 model fit results for a subject.}

\item{model}{[function]
A model function to be applied in evaluating the experimental effect.}

\item{model_name}{[character]
A character string specifying the name of the model to extract from the result.}

\item{param_prefix}{[character]
A prefix string used to identify parameter columns in the `result` data (e.g., "param_").}

\item{n_trials}{[integer]
Number of total trials in the experimental task.}
}
\value{
A list where each element contains the extracted results for one subject.
}
\description{
This function visualizes or extracts the model-estimated effect 
of reinforcement learning parameters for each subject.
}
