% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate_to_ppi.R
\name{add_expected_eta_to_scan}
\alias{add_expected_eta_to_scan}
\title{adds expected eta to a scan}
\usage{
add_expected_eta_to_scan(
  scan,
  vp,
  quantity = "dens",
  param = "DBZH",
  lat,
  lon,
  antenna,
  beam_angle = 1,
  k = 4/3,
  re = 6378,
  rp = 6357
)
}
\arguments{
\item{scan}{a scan (sweep) of class scan}

\item{vp}{a vertical profile of class vp}

\item{quantity}{profile quantity on which to base range corrections, 'eta' or 'dens'.}

\item{param}{reflectivity factor scan parameter on which to base range corrections.
Typically the same parameter from which animal densities are estimated for object \code{vp}.
One of 'DBZH','DBZV','DBZ','TH','TV'.}

\item{lat}{Geodetic latitude of the radar in degrees. If missing taken from \code{pvol}.}

\item{lon}{Geodetic latitude of the radar in degrees. If missing taken from \code{pvol}.}

\item{antenna}{radar antenna height. If missing taken from \code{vp}}

\item{beam_angle}{numeric. Beam opening angle in degrees, typically the
angle between the half-power (-3 dB) points of the main lobe}

\item{k}{Standard refraction coefficient.}

\item{re}{Earth equatorial radius in km.}

\item{rp}{Earth polar radius in km.}
}
\value{
an object of class 'scan'
}
\description{
adds expected eta to a scan
}
\details{
to be written
}
\keyword{internal}
