% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_basemap.R
\name{download_basemap}
\alias{download_basemap}
\title{Download a basemap for \code{map(ppi)}}
\usage{
download_basemap(
  x,
  verbose = TRUE,
  zoom,
  alpha = 1,
  source = "stamen",
  maptype = "terrain",
  ...
)
}
\arguments{
\item{x}{An object of class \code{ppi}.}

\item{verbose}{Logical, whether to print information to console.}

\item{zoom}{Zoom level (optional), see \link[ggmap]{get_map}. An integer
from 3 (continent) to 21 (building). By default the zoom level matching the
ppi extent is selected automatically.}

\item{alpha}{Transparency of the basemap (0-1).}

\item{source}{String identifying which map service should be used: "stamen" or "google".}

\item{maptype}{Type of basemap to plot. For Stamen Maps: "terrain",
"terrain-background", "terrain-labels", "terrain-lines", "toner",
"toner-2010", "toner-2011", "toner-background", "toner-hybrid",
"toner-labels", "toner-lines", "toner-lite", "watercolor". For Google
Maps: "terrain", "satellite", "roadmap", "hybrid"}

\item{...}{Arguments to pass to \link[ggmap]{get_map} function.}
}
\description{
Downloads a Stamen Maps or Google Maps base layer
map using \link[ggmap]{get_map}.
}
\details{
To use Google Maps as \code{source}, you will have to register with Google,
enable billing and provide an API key to ggmap. See the ggmap
\href{https://github.com/dkahle/ggmap#attention}{README} for details.

To use \code{maptype}, install the development version of ggmap (>3.0.0) with
\code{devtools::install_github("dkahle/ggmap")}.
}
\examples{
# load an example scan:
data(example_scan)

# print summary info for the scan:
example_scan

# make ppi for the scan
ppi <- project_as_ppi(example_scan)
\dontrun{
# grab a basemap that matches the extent of the ppi:
basemap <- download_basemap(ppi)

# map the reflectivity quantity of the ppi onto the basemap:
map(ppi, map = basemap, param = "DBZH")

# increase the transparancy of the basemap:
basemap <- download_basemap(ppi, alpha = 0.3)
map(ppi, map = basemap, param = "DBZH")

# download a different type of basemap, e.g. a gray-scale image:
# see get_map() in ggmap library for full documentation of options
basemap <- download_basemap(ppi, maptype = "toner-lite")

# map the radial velocities onto the line image:
map(ppi, map = basemap, param = "VRADH")
}
}
