% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_audio.R
\name{read_wac}
\alias{read_wac}
\title{Read WAC files from Wildlife Acoustics recorders}
\usage{
read_wac(file, time_exp = 1, write_wav = NULL, ...)
}
\arguments{
\item{file}{a WAC file.}

\item{time_exp}{integer. Time expansion factor of the recording.
Set to 1 for real-time recording or above for time expanded recording. Default setting is 1.}

\item{write_wav}{optional folder path where WAV files will be written.}

\item{...}{currently not implemented.}
}
\value{
A \link[tuneR]{Wave} object.
}
\description{
Convert a Wildlife Acoustics' proprietary compressed WAC file into a \link[tuneR]{Wave} object
}
\examples{
\donttest{
filepath <- system.file("extdata", "recording_20170716_230503.wac", package = "bioacoustics")
read_wac(filepath)
}

}
