% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_biobal.R
\name{biobal}
\alias{biobal}
\title{Computation of Bioclimatic Balance}
\usage{
biobal(balhid, CC)
}
\arguments{
\item{balhid}{Water balance.}

\item{CC}{Field capacity. It depends on water retention capacity and depth of roots. 400 as default value.}
}
\value{
data frame with 12 variables: 'p', 'Tm', 'PET', 'e', 'D', 'S', 'Cd', 'T_75', 'B', 'b', 'bl', 'bc'.
}
\description{
Computes bioclimatic balance from water balance.
}
\examples{
wb <- watbal(t = rnorm(12, 18, 6), p = rnorm(12, 50, 30), lat = 35, CC = 400)
biobal(wb, 400)
}
