#' \emph{biofiles} is an R package for interfacing with GenBank or
#' Embl flat file records.
#'
#' This is an R package for interfacing with GenBank, GenPept, Embl and
#' IMGT/HLA flat file records. It includes utilities for reading and writing
#' GenBank files, and methods for interacting with annotation and sequence data.
#' 
#' @author Gerhard Schöfl \email{gerhard.schofl@@gmail.com}
#' @references
#' For a sample GenBank record see
#' \url{https://www.ncbi.nlm.nih.gov/Sitemap/samplerecord.html}
#' 
#' For a detailed description of the GenBank feature table format see
#' \url{https://www.ncbi.nlm.nih.gov/collab/FT}
#'
#' For a description of the EMBL flat file format see
#' \url{ftp://ftp.ebi.ac.uk/pub/databases/embl/doc/usrman.txt}.
#' 
#' For a description of the format and conventions of IMGT/HLA flat files
#' see \url{https://www.ebi.ac.uk/ipd/imgt/hla/docs/manual.html}.
#'
#' @import methods Rcpp
#' @keywords package
#' @docType package
#' @name biofiles
NULL
