% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbLocation-class.R,
%   R/gbFeature-class.R, R/gbFeatureTable-class.R, R/gbRecord-class.R,
%   R/gbRecordList-class.R
\docType{methods}
\name{start}
\alias{start}
\alias{start<-}
\alias{start,gbLocation-method}
\alias{start<-,gbLocation-method}
\alias{start,gbFeature-method}
\alias{start<-,gbFeature-method}
\alias{start,gbFeatureTable-method}
\alias{start<-,gbFeatureTable-method}
\alias{start,gbRecord-method}
\alias{start,gbRecordList-method}
\title{Get or set the start position of genomic features}
\usage{
start(x, ...)

start(x, ...) <- value

\S4method{start}{gbLocation}(x, join = FALSE)

\S4method{start}{gbLocation}(x, ...) <- value

\S4method{start}{gbFeature}(x, join = FALSE)

\S4method{start}{gbFeature}(x, ...) <- value

\S4method{start}{gbFeatureTable}(x, join = FALSE)

\S4method{start}{gbFeatureTable}(x, ...) <- value

\S4method{start}{gbRecord}(x, join = FALSE)

\S4method{start}{gbRecordList}(x, join = FALSE)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}},
\code{\linkS4class{gbRecord}}, or \code{\linkS4class{gbRecordList}} object.}

\item{...}{Further arguments passed to methods.}

\item{value}{The start information to set on \code{x}.}

\item{join}{Join compound genomic locations into a single range.}
}
\value{
An integer vector or a list of integer vectors.
}
\description{
Get or set the start position of genomic features
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))

## start
start(x)
cds <- x["CDS"]
start(cds)

## `start<-`
start(cds) <- 10
start(cds)
}
\seealso{
\code{\link{end}}, \code{\link{strand}}, \code{\link{span}}, \code{\link{ranges}}
}
