% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeature-class.R,
%   R/gbFeatureTable-class.R, R/gbRecord-class.R, R/gbRecordList-class.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary,gbFeature-method}
\alias{summary,gbFeatureTable-method}
\alias{summary,gbRecord-method}
\alias{summary,gbRecordList-method}
\title{Summarise a GenBank record.}
\usage{
summary(object, ...)

\S4method{summary}{gbFeature}(object, ...)

\S4method{summary}{gbFeatureTable}(object, n = 8, ...)

\S4method{summary}{gbRecord}(object, n = 7, ...)

\S4method{summary}{gbRecordList}(object, n = 2, ...)
}
\arguments{
\item{object}{An object of class\code{\linkS4class{gbFeature}},
\code{\linkS4class{gbFeatureTable}}, \code{\linkS4class{gbRecord}}, or
\code{\linkS4class{gbRecordList}}.}

\item{...}{Arguments to be passed to methods.}

\item{n}{How many elements should be summarized in head and tail.}
}
\description{
Summarise a GenBank record.
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
summary(x)
}
