% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getFilters.R
\name{getFilters}
\alias{getFilters}
\title{Retrieve All Available Filters for a Specific Dataset}
\usage{
getFilters(mart, dataset)
}
\arguments{
\item{mart}{a character string specifying the database (mart) for which datasets shall be listed.}

\item{dataset}{a character string specifying the dataset for which filters shall be listed.}
}
\description{
This funcion queries the BioMart API and returns a table
storing all available filters for a specific dataset.
}
\examples{
# search for available datasets
head(getMarts(), 10)

\dontrun{

# choose database (mart): "plants_mart_25" -> Note: mart versions change over time
# and get a table of all available datasets from this BioMart database
head(getDatasets(mart = "plants_mart_25"), 10)

# choose dataset: "athaliana_eg_gene"
head(getFilters(mart = "plants_mart_25", dataset = "athaliana_eg_gene") , 5)

}
}
\author{
Hajk-Georg Drost
}
\seealso{
\code{\link{getMarts}}, \code{\link{getDatasets}}, \code{\link{getAttributes}}, \code{\link{organismBM}}, \code{\link{organismFilters}}, \code{\link{organismAttributes}}
}

