% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sequence_io.R
\name{read_cds}
\alias{read_cds}
\title{Read the CDS of a given Organism}
\usage{
read_cds(file, format, delete_corrupt = FALSE, ...)
}
\arguments{
\item{file}{a character string specifying the path to the file storing the CDS.}

\item{format}{a character string specifying the file format used to store the CDS, e.g. "fasta", "gbk".}

\item{delete_corrupt}{a logical value specifying whether potential CDS sequences that cannot be divided by 3 shall be
be excluded from the the dataset. Default is \code{delete_corrupt = FALSE}.}

\item{...}{additional arguments that are used by the seqinr::read.fasta() function.}
}
\value{
A data.table storing the gene id in the first column and the corresponding
sequence as string in the second column.
}
\description{
This function reads an organism specific CDS stored in a defined file format.
}
\details{
The \code{read.cds} function takes a string specifying the path to the cds file
of interest as first argument.

It is possible to read in different proteome file standards such as \emph{fasta} or \emph{genebank}.

CDS stored in fasta files can be downloaded from http://www.ensembl.org/info/data/ftp/index.html.
}
\examples{
\dontrun{
# reading a cds file stored in fasta format
Ath.cds <- read.cds(system.file('seqs/ortho_thal_cds.fasta', package = 'orthologr'),
                    format = "fasta")
}
}
\author{
Hajk-Georg Drost
}

