#' @title Genomic Data Retrieval
#'
#' @description This package interacts with a suite of web Application 
#' Programming Interfaces and FTP sites to perform automated genomic data 
#' retieval and annotation information retrieval.
#'
#' @section About:
#' To automate the retrieval process on a meta-genomic scale, this package
#'  provides useful interface functions for genomic sequence retrieval and 
#'  functional annotation retrieval. 
#'  The major aim of \code{biomartr} is to facilitate computational 
#'  reproducibility and large-scale handling of genomic data for 
#'  (meta-)genomic analyses. 
#'   
#' In detail, \code{biomartr} aims to provide users with an easy to use 
#' framework to obtain genome, proteome, CDS, GFF (annotation), genome 
#' assembly quality, and metagenome project data. Furthermore, an interface to 
#' the Ensembl Biomart database allows users to retrieve functional annotation 
#' for genomic loci.
#' Users can download entire databases
#' such as 
#' \itemize{
#' \item \code{NCBI RefSeq}
#' \item \code{NCBI nr}
#' \item \code{NCBI nt}
#' \item \code{NCBI Genbank}
#' \item \code{NCBI nt}
#' \item \code{Ensembl}
#' \item \code{Ensembl Genomes}
#' }
#' @name biomartr-package
#' @aliases biomartr
#' @docType package
#' @author Hajk-Georg Drost \email{hgd23@cam.ac.uk}
#' @keywords package
NULL
