% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\name{master_selection}
\alias{master_selection}
\alias{new_master_selection}
\title{Constructor of S3 objects of class master_selection}
\usage{
new_master_selection(data_matrix, preselected_sites = NULL, region,
                     mask = NULL, raster_base, PCA_results = NULL,
                     selected_sites_random = NULL, selected_sites_G = NULL,
                     selected_sites_E = NULL, selected_sites_EG = NULL)
}
\arguments{
\item{data_matrix}{date.frame with information about geographic location of
raster cells, initial environmental data, and if available, the first two
principal components derived from an analysis done with environmental values.}

\item{preselected_sites}{data.frame containing sites that must be included
in posterior selections of sites for the survey system. Columns must be:
"Sites", "Longitude", "Latitude", in that order. Default = NULL.}

\item{region}{SpatialPolygons* object representing the region of interest.}

\item{mask}{SpatialPolygons* object used. Default = NULL.}

\item{raster_base}{a SpatialPolygonsDataFrame representing the grid of the
raster layers used, which will be used for plotting purposes.}

\item{PCA_results}{results of principal component analysis performed with
values from raster layers used. Default = NULL.}

\item{selected_sites_random}{data.frame with the sites selected randomly.
Default = NULL.}

\item{selected_sites_G}{data.frame with the sites selected based on
geographic distances. Default = NULL.}

\item{selected_sites_E}{data.frame with the sites selected based on
environmental distances. Default = NULL.}

\item{selected_sites_EG}{data.frame with the sites selected based on
environmental and geographic considerations. Default = NULL.}
}
\value{
An S3 object of class \code{master_selection}.
}
\description{
Constructor of S3 objects of class master_selection
}
