\name{web2edges}

\alias{web2edges}

\title{Conversion of a network matrix into a (weighted) edge list}

\description{
 This helper function converts a bipartite matrix into an edge list, optionally weighted, as used by other packages and software, and writes this to the hard drive (optionally)
}

\usage{
web2edges(web, webName=NULL, weight.column=TRUE, both.directions=FALSE, 
	is.one.mode=FALSE, out.files=c("edges", "names", "groups")[1:2],
	return=FALSE, verbose=FALSE)
}

\arguments{
  \item{web}{A matrix with lower trophic level species as rows, higher trophic level species 
    as columns and number of interactions as entries.}
  \item{webName}{An optional name for the data file generated by the function.}
  \item{weight.column}{Logical; is the web quantitative and should hence a weighted edge list be produced? Defaults to TRUE.}
  \item{both.directions}{Logical; shall each link be represented twice, i.e. once from A to B and also from B to A? Defaults to FALSE.}
  \item{is.one.mode}{Logical; if TRUE, labels for species will be used as they currently are in the web; otherwise, species will be re-labelled so that the first column will have number NROW(web) + 1. This is also the default.}
  \item{out.files}{String indicating which files to produce: "edges" writes an edge list, "names" writes a list with names belonging to the edges and "groups" writes a file assigning the species to higher and lower trophic levels. The default produces the edge list and the names file.}
  \item{return}{Logical; shall the edge list be returned by this function (for future use in R)? Defaults to FALSE. Setting \option{return} to TRUE will prevent writing of files to the hard drive!}
  \item{verbose}{Logical; shall some feedback tell you that the files have been generated? Defaults to FALSE.}
}

\details{
Many network programs (e.g. Pajek) require input in the form of an edge list. Here each species is a number. The edge list has two column, one with the target and one with the origin of the connection. That means an interaction between 1 and 6 would be written (in one line) as:  "1  6". In a weighted edge list, a third column represents the strength of the interaction: "1  6  4.77".
	
All this function does is to transform the typical interaction matrix used in bipartite into an edge list. Within R this could be used e.g. in the package \pkg{tnet}; outside R by Pajek or others.

Similar to \code{\link{as.one.mode}} this function is there to increase interchange between different coding standards and packages.

}

\value{
  A matrix ("edge list") with two (unweighted) or three (weighted) columns. 
  
  If return=FALSE, this matrix (and possibly names and groups) are written to a text-file in the working directory.
}

\author{ Carsten F. Dormann \email{carsten.dormann@ufz.de} }

\note{ 
The function is used as export helper (default) or as link to \pkg{tnet} (with return=TRUE).
}

\examples{
data(Safariland)
web2edges(Safariland, return=TRUE)
}

\keyword{package}

