% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCA.R
\name{PCA.biplot}
\alias{PCA.biplot}
\title{PCA biplot}
\usage{
\method{PCA}{biplot}(
  bp,
  dim.biplot = c(2, 1, 3),
  e.vects = 1:ncol(bp$X),
  group.aes = NULL,
  show.group.means = FALSE,
  correlation.biplot = FALSE
)
}
\arguments{
\item{bp}{an object of class \code{biplot} obtained from preceding function \code{biplot()}.}

\item{dim.biplot}{dimension of the biplot. Only values 1, 2 and 3 are accepted, with default \code{2}.}

\item{e.vects}{which eigenvectors (principal components) to extract, with default \code{1:dim.biplot}.}

\item{group.aes}{vector of the same length as the number of rows in the data matrix
for differentiated aesthetics for samples.}

\item{show.group.means}{logical, indicating whether group means should be plotted in the biplot.}

\item{correlation.biplot}{logical, if \code{FALSE}, the distances between sample points are
optimally approximated in the biplot. If \code{TRUE}, the correlations between
variables are optimally approximated by the cosine of the angles between
axes. Default is \code{FALSE}.}
}
\value{
an object of class PCA, inherits from class biplot.
}
\description{
Performs calculations for a PCA biplot.
}
\examples{
biplot(iris[,1:4]) |> PCA()
# create a PCA biplot
biplot(data = iris) |> PCA() |> plot()

}
