% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bisg.R
\name{p_r_natl}
\alias{p_r_natl}
\title{National Racial Demographics}
\usage{
p_r_natl(year = 2021, vap = FALSE)
}
\arguments{
\item{year}{The year to return demographics for.}

\item{vap}{If `TRUE`, return statistics for the voting-age population (18+)
rather than the full U.S. population.}
}
\value{
A named numeric vector of length 6.
}
\description{
Returns the proportion of the U.S. population in six racial groups in a given
year. Group definitions necessarily follow those used by the Census Bureau in
its surname tables:
* `white`: Non-Hispanic White alone
* `black`: Non-Hispanic Black alone
* `hisp`: Hispanic, any race
* `asian`: Non-Hispanic Asian, Native Hawaiian, or Pacific Islander alone
* `aian`: Non-Hispanic American Indian/Alaska Native
* `other`: Non-Hispanic, two or more races, or other race
}
\examples{
p_r_natl(year=2010)

}
