% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/farming_crops_16x16.R
\name{farming_crops_16x16}
\alias{farming_crops_16x16}
\title{Sprites for twenty farming crops}
\usage{
farming_crops_16x16()
}
\value{
A named list of \code{\link[=bm_list]{bm_list()}} lists of six \code{\link[=bm_pixmap]{bm_pixmap()}} objects (one through five stages of growth plus a portrait for each crop).  The named list has the following twenty crop names:
\itemize{
\item "avocado"
\item "cassava"
\item "coffee"
\item "corn"
\item "cucumber"
\item "eggplant"
\item "grapes"
\item "lemon"
\item "melon"
\item "orange"
\item "pineapple"
\item "potato"
\item "rice"
\item "rose"
\item "strawberry"
\item "sunflower"
\item "tomato"
\item "tulip"
\item "turnip"
\item "wheat"
}
}
\description{
\code{farming_crops_16x16()} returns a named list of \code{\link[=bm_list]{bm_list()}} lists
of twenty farming crops in five stages of growth plus a portrait as \code{\link[=bm_pixmap]{bm_pixmap()}} objects.
}
\details{
\itemize{
\item Each sprite is sixteen by sixteen pixels large.
\item \href{https://opengameart.org/content/farming-crops-16x16}{Farming Crops 16x16} was made and dedicated to the public domain by \href{https://opengameart.org/users/josehzz}{josehzz}.
}
}
\examples{
crops <- farming_crops_16x16()
names(crops)
if (cli::is_utf8_output() && cli::num_ansi_colors() >= 256L) {
  print(crops$corn$portrait, compress = "v")
}

if (cli::is_utf8_output() && cli::num_ansi_colors() >= 256L) {
  print(crops$orange$stage5, compress = "v")
}
}
