% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_statistics.R
\docType{class}
\name{ChiSquare-class}
\alias{ChiSquare-class}
\alias{ChiSquare}
\alias{setupChiSquare}
\title{Chi-squared test}
\usage{
setupChiSquare(
  alpha,
  beta,
  r = 1,
  delta,
  alternative = c("greater", "smaller"),
  n_max = Inf,
  ...
)
}
\arguments{
\item{alpha}{One-sided type I error rate.}

\item{beta}{Type II error rate.}

\item{r}{Allocation ratio between experimental and control group.}

\item{delta}{Difference of effect size between alternative and null hypothesis.}

\item{alternative}{Does the alternative hypothesis contain greater
(\code{greater}) or smaller (\code{smaller}) values than the
null hypothesis.}

\item{n_max}{Maximal overall sample size. If the recalculated sample size
is greater than \code{n_max} it is set to \code{n_max}.}

\item{...}{Further optional arguments.}
}
\value{
An object of class \code{\link{ChiSquare}}.
}
\description{
This class implements a chi-squared test for superiority trials. A trial
with binary outcomes in two groups \code{T} and \code{C} is assumed.

The function \code{setupChiSquare} creates an object of class
\code{\link{ChiSquare}}.
}
\details{
The following methods are available for this class:
\code{\link{toer}}, \code{\link{pow}}, \code{\link{n_dist}},
\code{\link{adjusted_alpha}}, and \code{\link{n_fix}}.
Check the design specific documentation for details.

For non-inferiority trials use the function \code{\link{setupFarringtonManning}}.
}
\examples{
design <- setupChiSquare(alpha = .025, beta = .2, r = 1, delta = 0.2,
alternative = "greater")

}
