% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChiSquare.R
\name{n_dist,ChiSquare-method}
\alias{n_dist,ChiSquare-method}
\title{Distribution of the Sample Size}
\usage{
\S4method{n_dist}{ChiSquare}(
  design,
  n1,
  nuisance,
  summary = TRUE,
  plot = FALSE,
  allocation = c("exact", "approximate"),
  ...
)
}
\arguments{
\item{design}{Object of class \code{ChiSquare} created by \code{setupChiSquare}.}

\item{n1}{Either the sample size of the first stage (if
\code{recalculation = TRUE} or the toal sample size (if
\code{recalculation = FALSE}).}

\item{nuisance}{Value of the nuisance parameter. For the
Chi-Squared test this is the overall response rate.}

\item{summary}{Logical. If \code{TRUE} (default) a summary of the sample
size distribution is printed. If \code{FALSE} all sample sizes are
printed.}

\item{plot}{Should a plot of the sample size distribution
be drawn?}

\item{allocation}{Whether the allocation ratio should be preserved
exactly (\code{exact}) or approximately (\code{approximate}
or \code{kf_approx}). \code{appproximate} uses the unrounded calculated
sample size in the sample size recalculation, \code{kf_approx}
rounds the sample size to the next integer.}

\item{...}{Further optional arguments.}
}
\value{
Summary and/or plot of the sample size distribution for
  every nuisance parameter and every value of n1.
}
\description{
Calculates the distribution of the total sample sizes of designs
with blinded sample size recalculation for different values of the
nuisance parameter or of n1.
}
\details{
Only sample sizes that occur with a probability of at least 0.01% are
considered.

The method is only vectorized in either \code{nuisance}
  or \code{n1}.
}
\examples{
  d <- setupChiSquare(alpha = 0.025, beta = 0.2, r = 1, delta = 0.2)
  n_dist(d, n1 = 20, nuisance = 0.25, summary = TRUE, plot = FALSE)

}
