% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-model-fit-stats.R
\name{blr_rsq_mcfadden}
\alias{blr_rsq_mcfadden}
\title{McFadden's R2}
\usage{
blr_rsq_mcfadden(model)
}
\arguments{
\item{model}{An object of class \code{glm}.}
}
\value{
McFadden's r-squared.
}
\description{
McFadden's pseudo r-squared for the model.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
            family = binomial(link = 'logit'))

blr_rsq_mcfadden(model)

}
\references{
McFadden, D. (1974) “Conditional logit analysis of qualitative choice behavior.” 
Pp. 105-142 in P. Zarembka (ed.), Frontiers in Econometrics. Academic Press.
}
